/************************************************************************\
\************************************************************************/

typedef unsigned short	UShort;


UShort uni2isoTbl[] = {
	0,   1,   2,   3,    4,  5,   6,   7,   8,   9,   10,  11,  12,  13,  14,  15,
	16,  17,  18,  19,   20, 21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
	32,  33,  34,  35,   36, 37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
	48,  49,  50,  51,   52, 53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
	64,  65,  66,  67,   68, 69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,
	80,  81,  82,  83,   84, 85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,
	96,  97,  98,  99,  100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
	112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,

	0x2022, 0x2122, 0x2260, 0x221E, 0x2265, 0x2211, 0x222B, 0x2126,
	0x221A, 0x2248, 0x2026, 0x2014, 0x2018, 0x0178, 0x2044, 0x2202,
	0x2206, 0x0152, 0x201A, 0x201E, 0x2030, 0xF7FF, 0x02C6, 0x02DC,
	0x02D8, 0x02D9, 0x02DA, 0x02DD, 0x02DB, 0x02C7, 0x0131, 0x0192,
	0x00A0, 0x00A1, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x0153, 0x00A7,
	0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x2013, 0x00AE, 0x00AF,
	0x00B0, 0x00B1, 0x201D, 0x201C, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
	0x00B8, 0x2019, 0x00BA, 0x00BB, 0x03C0, 0x220F, 0x2264, 0x00BF,
	0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7,
	0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
	0x2039, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x25CA,
	0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x2020, 0xFB01, 0x00DF,
	0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7,
	0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
	0x203A, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7,
	0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x2021, 0xFB02, 0x00FF
};


//#include "objects.h"
//#include "NewtonScript.h"
//#include "applefile.h"

typedef unsigned long	ULong;
typedef unsigned char	UByte;

char	*result;

void _WrapTxQuoted ( UShort *src, char *dest, long maxW );
static void _finishLine ( char *buff, long ix, char doQuote );
static long _stuffQPChar ( char *buff, long offset, UShort uniChar );
static void _stuffQHex ( char *buff, long ix, UByte hexV );


void _WrapTxQuoted ( UShort *src, char *dest, long maxW )
{
	//char	outBuff[256];
	char	*outBuff = dest;
	long	i = 0;
	long	k = 0;
	UShort	ch;
	long	prevSrcSpc = 0;
	long	prevDstSpc = 0;

	result = outBuff;

	while ( ch = src[i] )
	{
		// quote first "." character on a line
		if ( k == 0 && ch == 0x2E )
		{
			k = _stuffQPChar ( outBuff, k, ch );
			i++;
		}
		else
		{
			if ( k > maxW && ch != 0x0D )
			{
				// split right here if no spaces in this line
				if ( prevSrcSpc < maxW / 4 )
				{
					_finishLine ( outBuff, k, true );
					k = 0;
				}
				else
				{
					//k = prevDstSpc;
					_finishLine ( outBuff, prevDstSpc, true );

					i = prevSrcSpc;
					prevSrcSpc = 0;
					k = 0;
				}
			}
			else
			{
				// keep track of <SPC> char positions
				if ( ch == 0x20 )
				{
					prevSrcSpc = i;
					prevDstSpc = k;
				}

				// do characters which have to be quoted
				if ( ch == '=' || ch > 0x7F )
				{
					k = _stuffQPChar ( outBuff, k, ch );
					i++;
				}

				// if we're at a <CR> finish the line and reset "k"
				else if ( ch == 0x0D )
				{
					_finishLine ( outBuff, k, nil );
					i++;
					prevSrcSpc = prevDstSpc = k = 0;
				}

				// just stuff in normal characters
				else
				{
					outBuff [ k++ ] = ch;
					i++;
				}
			}
		}
	}
	if ( k > 0 )
		_finishLine ( outBuff, k, nil );
}


void _finishLine ( char *buff, long ix, char doQuote )
{
	if ( doQuote )
		buff [ ix++ ] = '=';

	buff [ ix ] = 0x0D;
	buff [ ix+1 ] = 0x00;
}


long _stuffQPChar ( char *buff, long offset, UShort uniChar )
{
	if ( uniChar < 0x80 )
	{
		_stuffQHex ( buff, offset, uniChar & 0xFF );
		return offset + 3;
	}
	else
	{
		long	n;
		for ( n = 0x80; n < 256; n++ )
		{
			if ( uni2isoTbl[n] == uniChar )
			{
				_stuffQHex ( buff, offset, n & 0xFF );
				return offset + 3;
			}
		}
	}
	return offset;
}


void _stuffQHex ( char *buff, long ix, UByte hexV )
{
	char *hexS = "0123456789ABCDEF";

	buff [ ix++ ] = '=';
	char	c = hexS [ (hexV >> 4) & 0x0F ];
	buff [ ix++ ] = c;
	c = hexS [ hexV & 0x0F ];
	buff [ ix ] = c;
}

/************************************************************

/*
void BlockMove ( const void * srcPtr, void * destPtr, Size byteCount );
void			DisposPtr(Ptr p);
Size			GetPtrSize(Ptr p);
Ptr				NewPtr(Size size);
Ptr				NewPtrClear(Size byteCount);
Heap			PtrToHeap(Ptr);
Ptr				ReallocPtr(Ptr, Size);			// like realloc


Size			TotalFreeInHeap(Heap DEFAULT_NIL);
Size			LargestFreeInHeap(Heap DEFAULT_NIL);
unsigned long	CountFreeBlocks(Heap DEFAULT_NIL);
Size			TotalUsedInHeap(Heap DEFAULT_NIL);
Size			MaxHeapSize(Heap DEFAULT_NIL);

//____________________________________________________________________
// Frame & Slot Functions

extern	Ref		AllocateFrame(void);
extern	Boolean	FrameHasPath(RefArg obj, RefArg thePath);
extern	Boolean	FrameHasSlot(RefArg obj, RefArg slot);
extern	Ref		GetFramePath(RefArg obj, RefArg thePath);
extern	Ref		GetFrameSlot(RefArg obj, RefArg slot);
extern	long	Length ( RefArg obj );		// Length in bytes or slots
extern	void	MapSlots(RefArg obj, MapSlotsFunction func, ULong anything);

extern	void	RemoveSlot(RefArg frame, RefArg tag);
extern	void	SetFramePath(RefArg obj, RefArg thePath, RefArg value);		
extern	void	SetFrameSlot(RefArg obj, RefArg slot, RefArg value);
extern	void	SetLength(RefArg obj, long length);

extern	Ref		MakeString(const char* str);

*/
